package br.com.mzsw;

/**
 * Interface que recebe os eventos de recebimento de peso e conexo com uma balana
 * 
 * @author Mazin
 *
 */
public interface BalancaListener {
	/**
	 * Conectou-se a uma balana
	 * 
	 * @param sender instancia da balana
	 */
	public void onConectado(Object sender);
	
	/**
	 * Recebeu um peso da balana
	 * 
	 * @param sender instancia da balana
	 * @param gramas peso em gramas do item que est sobre a balana
	 */
	public void onPesoRecebido(Object sender, int gramas);
	
	/**
	 * Desconectou-se de uma balana
	 * 
	 * @param sender instancia da balana
	 */
	public void onDesconectado(Object sender);
}
